------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--     A D A . F I N A L I Z A T I O N . H E A P _ M A N A G E M E N T      --
--                                                                          --
--                                S p e c                                   --
--                                                                          --
--          Copyright (C) 2008-2011, Free Software Foundation, Inc.         --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This is a .NET/JVM-specific version

with System.Finalization_Root;

package Ada.Finalization.Heap_Management is

   --  ??? Comment needed on overall mechanism

   type Finalization_Collection is
     new Ada.Finalization.Limited_Controlled with private;

   type Finalization_Collection_Ptr is access all Finalization_Collection;
   for Finalization_Collection_Ptr'Storage_Size use 0;

   procedure Attach
     (Collection : in out Finalization_Collection;
      Obj        : System.Finalization_Root.Root_Controlled_Ptr);
   --  Prepend an object to a specific collection

   procedure Detach (Obj : System.Finalization_Root.Root_Controlled_Ptr);
   --  Remove an object from an arbitrary list

   overriding procedure Finalize
     (Collection : in out Finalization_Collection);
   --  Traverse the objects of Collection, invoking Finalize_Address on eanch
   --  of them. In the end, the routine destroys its dummy head and tail.

   overriding procedure Initialize
     (Collection : in out Finalization_Collection);
   --  Create a new Collection by allocating a dummy head and tal

private
   type Finalization_Collection is
     new Ada.Finalization.Limited_Controlled with
   record
      Objects : System.Finalization_Root.Root_Controlled_Ptr := null;
      --  The head of a doubly linked list

      Finalization_Started : Boolean := False;
      --  When the finalization of a collection takes place, any allocations on
      --  the same collection are prohibited and the action must raise Program_
      --  Error.
   end record;

   procedure pcol (Collection : Finalization_Collection);
   --  Output the contents of a collection in a readable form. Intended for
   --  debugging purposes.

end Ada.Finalization.Heap_Management;
