------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                        Copyright (C) 2014, AdaCore                       --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO; use Ada.Text_IO;
with Ada.Command_Line; use Ada.Command_Line;
with Ada.Directories; use Ada.Directories;

package body Errors is

   -----------------
   -- Print_Error --
   -----------------

   procedure Print_Error (Msg : String) is
   begin
      Put_Line (Standard_Error, Simple_Name (Command_Name) & ": " & Msg);
   end Print_Error;

   -----------
   -- Error --
   -----------

   procedure Error (Msg : String) is
   begin
      Print_Error (Msg);
      Set_Exit_Status (Failure);
   end Error;

   -----------------
   -- Fatal_Error --
   -----------------

   procedure Fatal_Error (Msg : String) is
   begin
      Error (Msg);
      raise Exec_Error;
   end Fatal_Error;

end Errors;
