------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                     Copyright (C) 2010-2015, AdaCore                     --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Strings; use GNAT.Strings;
with Driver_Type; use Driver_Type;
with GNAT.OS_Lib;

package Driver_Target is
   Driver_Table : array (1 .. 1) of Driver_Target_Type :=
     (1 =>
        (Build_Command => null,
         Build_Options => null,
         Run_Command => new String'("qemu-system-ppc" &
                                      GNAT.OS_Lib.Get_Executable_Suffix.all),
         Run_Options => new String_List'(
           new String'("-nographic"),
           new String'("-M"),
           new String'("wrsbc834x_vxworks"),
           new String'("-no-reboot"),
           new String'("-L"),
           new String'("."),
           new String'("-bios"),
           new String'("-"),
           new String'("-net"),
           new String'("user,vlan=0,net=192.168.0.0/24,host=192.168.0.1"
                         & ",dhcpstart=192.168.0.2,tftp=$tftp_root,$hostfwd"),
           new String'("-net"),
           new String'("nic,model=eTSEC,vlan=0"),
           new String'("-kernel"),
           new String'("$kernel")),
         Target => new String'("ppc-vx6"),
         Target_String => new String'("PowerPC VxWorks 6"),
         Board => new String'("wrSbc834x"),
         RTS_Keyword => new String'("")
        ));
end Driver_Target;
