------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                     Copyright (C) 2010-2015, AdaCore                     --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Strings; use GNAT.Strings;
with Driver_Type; use Driver_Type;
with GNAT.OS_Lib;

package Driver_Target is
   Driver_Table : array (1 .. 3) of Driver_Target_Type :=
     (1 =>
        (Build_Command => null,
         Build_Options => null,
         Run_Command => new String'("qemu-system-arm" &
                                      GNAT.OS_Lib.Get_Executable_Suffix.all),
         Run_Options => new String_List'(
           new String'("-nographic"),
           new String'("-no-reboot"),
           new String'("-M"),
           new String'("lm3s6965evb"),
           new String'("-kernel"),
           new String'("$exe")),
         Target => new String'("arm-elf"),
         Target_String => new String'("ARM Bareboard (Cortex-M3)"),
         Board => new String'("lm3s6965evb"),
         RTS_Keyword => new String'("lm3s")
        ),
      2 =>
        (Build_Command => null,
         Build_Options => null,
         Run_Command => new String'("qemu-system-arm" &
                                      GNAT.OS_Lib.Get_Executable_Suffix.all),
         Run_Options => new String_List'(
           new String'("-nographic"),
           new String'("-no-reboot"),
           new String'("-M"),
           new String'("stm32"),
           new String'("-cpu"),
           new String'("cortex-m4f"),
           new String'("-semihosting"),
           new String'("-kernel"),
           new String'("$exe")),
         Target => new String'("arm-elf"),
         Target_String => new String'("ARM Bareboard (Cortex-M4F)"),
         Board => new String'("STM32F4"),
         RTS_Keyword => new String'("stm32f4")
        ),
      3 =>
        (Build_Command => null,
         Build_Options => null,
         Run_Command => new String'("qemu-system-armeb" &
                                      GNAT.OS_Lib.Get_Executable_Suffix.all),
         Run_Options => new String_List'(
           new String'("-nographic"),
           new String'("-no-reboot"),
           new String'("-M"),
           new String'("TMS570"),
           new String'("-kernel"),
           new String'("$exe")),
         Target => new String'("arm-elf"),
         Target_String => new String'("ARM Bareboard (Cortex-R4F)"),
         Board => new String'("TMS570"),
         RTS_Keyword => new String'("tms570")
        ));
end Driver_Target;
