------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                       Copyright (C) 2014, AdaCore                        --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Strings; use GNAT.Strings;

package Project is

   procedure Load_Root_Project (Prj_Name : String);
   --  Load the project tree rooted at Prj_Name (with optional
   --  Project_File_Extension).

   --  All the following routines may only be called after Load_Root_Project.

   procedure Add_Scenario_Var (Key, Value : String);
   --  Set the indicated scenario variable to the given value

   procedure Compute_Project_View;
   --  Recompute the view of the loaded project within the current scenario

   --------------------------------------
   -- Accessors for project properties --
   --------------------------------------

   function Switches return String_List_Access;
   --  Return a list of gnatcov switches defined by the root project. Caller
   --  is responsible for deallocation.

   function Board return String;
   --  Return value of board attribute.

   function Debug_Port return String;
   --  Return value of Debug_Port attribute or the default value.

   function Board_From_Runtime return String;
   --  Try to guess board using the run-time name

end Project;
