------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                     Copyright (C) 2010-2015, AdaCore                     --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Strings; use GNAT.Strings;

package Driver_Type is
   type Driver_Target_Type is record
      --  Post-build command and option list (may be null)

      Build_Command : String_Access;
      Build_Options : String_List_Access;

      --  Run command and option list

      Run_Command   : String_Access;
      Run_Options   : String_List_Access;

      Target : String_Access;
      --  technical target name: ppc-elf, leon-elf, ...

      Target_String : String_Access;
      --  long target name used in version display

      Board : String_Access;
      --  Board name for --board switch

      RTS_Keyword : String_Access;
      --  Keywork to look for in Run-time name
   end record;
end Driver_Type;
