------------------------------------------------------------------------------
--                                                                          --
--                          B U S I N T E R F A C E                         --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                     Copyright (C) 2011-2018, AdaCore                     --
--                                                                          --
-- This program is free software;  you can redistribute it and/or modify it --
-- under terms of  the GNU General Public License as  published by the Free --
-- Softwareg Foundation;  either version 3,  or (at your option)  any later --
-- version. This progran is distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy  of the GNU General Public License and a --
-- copy of the  GCC Runtime Library Exception along  with this program; see --
-- the  files  COPYING3  and  COPYING.RUNTIME  respectively.  If  not,  see --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

package body BusInterface is

   package C renames Interfaces.C;

   procedure C_Set_Device_Info (Device : Internal_Bus_Device;
                                Opaque               : Opaque_Ptr;
                                Vendor_Id, Device_Id : Id;
                                Endianness           : Device_Endianness;
                                Name, Description    : C.char_array);
   pragma Import (C, C_Set_Device_Info, "set_device_info");

   ---------------------
   -- Set_Device_Info --
   ---------------------

   procedure Set_Device_Info (Device : Internal_Bus_Device;
                              Opaque               : Opaque_Ptr;
                              Vendor_Id, Device_Id : Id;
                              Endianness           : Device_Endianness;
                              Name, Description : String)
   is
   begin

      --  Wrapper to convert Ada String to C char_array

      C_Set_Device_Info (Device, Opaque, Vendor_Id, Device_Id, Endianness,
                         Interfaces.C.To_C (Name),
                         Interfaces.C.To_C (Description));
   end Set_Device_Info;

   procedure C_Register_Shared_Memory (Device : Internal_Bus_Device;
                                       Address, Length : Bus_Address;
                                       Name : C.char_array);
   pragma Import (C, C_Register_Shared_Memory, "register_shared_memory");

   procedure Register_Shared_Memory (Device : Internal_Bus_Device;
                                     Address, Length : Bus_Address;
                                     Name : String)
   is
   begin
      C_Register_Shared_Memory (Device, Address, Length,
                                Interfaces.C.To_C (Name));
   end Register_Shared_Memory;

end BusInterface;
