------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                       Copyright (C) 2013, AdaCore                        --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with UART; use UART;
with Ada.Text_IO;

procedure Main is
   My_UART : UART.UART_Ref;
begin
   My_UART := new UART.UART_Device (16#ffff_ffff#, --  Vendor_Id
                                    16#aaaa_aaaa#, --  Device_Id
                                    16#f800_1000#, --  Base Address
                                    8032);         --  TCP Port
   --  Start the Device loop

   My_UART.Start;

   --  Now we are ready to receive connection from GNATemulator

   Ada.Text_IO.Put_Line ("Start Simulation");

   for Cnt in 1 .. 160 loop
      My_UART.UC.Put ("Send Message: " & Cnt'Img & ASCII.LF);
      Ada.Text_IO.Put_Line ("Send Message: " & Cnt'Img & ASCII.LF);
      delay 1.0;
   end loop;

   --  Abort the device loop

   My_UART.Kill;
end Main;
