------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with Data_Container; use Data_Container;
with Glib; use Glib;
with Device; use Device;
with Speed_Probe_Gtk; use Speed_Probe_Gtk;
with Gtk; use Gtk;
with Gtk.Main;

procedure Main_GtkAda is
   Speed_Data   : aliased Data_Container_Record;
   Error_Data   : aliased Data_Container_Record;

   My_Device    : Device.Device_Ref;

   Sp_Gtk : aliased Speed_Probe_Gtk_Record;
begin

   Speed_Data.X := new Gdouble_Array (1 .. 50);
   Speed_Data.Y := new Gdouble_Array (1 .. 50);
   Error_Data.X := new Gdouble_Array (1 .. 50);
   Error_Data.Y := new Gdouble_Array (1 .. 50);

   --  Create the GNATbus device
   My_Device := new Device.Device_T (16#ffff_ffff#,  --  Vendor_Id
                                     16#aaaa_aaaa#,  --  Device_Id
                                     8032,           --  TCP Port
                                     16#8001_0000#,  --  Base Address
                                     Speed_Data'Unchecked_Access,
                                     Error_Data'Unchecked_Access);

   Init_Gtk (Sp_Gtk'Unchecked_Access,
             My_Device,
             Speed_Data'Unchecked_Access,
             Error_Data'Unchecked_Access);

   My_Device.Start;
   Gtk.Main.Main;
   My_Device.Kill;
end Main_GtkAda;
