/****************************************************************************
 *                                                                          *
 *                      G N A T E M U _ H O S T F S . H                     *
 *                                                                          *
 *                        Copyright (C) 2012, AdaCore                       *
 *                                                                          *
 * This program is free software;  you can redistribute it and/or modify it *
 * under terms of  the GNU General Public License as  published by the Free *
 * Softwareg Foundation;  either version 3,  or (at your option)  any later *
 * version. This progran is distributed in the hope that it will be useful, *
 * but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     *
 *                                                                          *
 * As a special exception under Section 7 of GPL version 3, you are granted *
 * additional permissions  described in the GCC  Runtime Library Exception, *
 * version 3.1, as published by the Free Software Foundation.               *
 *                                                                          *
 * You should have received a copy  of the GNU General Public License and a *
 * copy of the  GCC Runtime Library Exception along  with this program; see *
 * the  files  COPYING3  and  COPYING.RUNTIME  respectively.  If  not,  see *
 * <http://www.gnu.org/licenses/>.                                          *
 *                                                                          *
 ****************************************************************************/

#ifndef GNATEMU_HOSTFS_H_
#define GNATEMU_HOSTFS_H_

#include<types.h>

/* HostFS open flags */
#define HOSTFS_O_RDONLY (1 << 0)
#define HOSTFS_O_WRONLY (1 << 1)
#define HOSTFS_O_CREAT  (1 << 2)
#define HOSTFS_O_RDWR   (1 << 3)
#define HOSTFS_O_APPEND (1 << 4)
#define HOSTFS_O_TRUNC  (1 << 5)
#define HOSTFS_O_BINARY (1 << 6)

uint32_t hfs_open(const char *pathname, uint32_t flags, uint32_t mode);
uint32_t hfs_read(uint32_t fd, void *buf, uint32_t count);
uint32_t hfs_write(uint32_t fd, const void *buf, uint32_t count);
uint32_t hfs_close(uint32_t fd);

uint32_t hfs_copy_from_host(const char *host_filename, const char *local_filename);

#endif /* ! GNATEMU_HOSTFS_H_ */
