------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                       Copyright (C) 2016, AdaCore                        --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.OS_Lib; use GNAT.OS_Lib;
with Ada.Text_IO; use Ada.Text_IO;

procedure Main is
   File : File_Descriptor;
   Filename : constant Standard.String := "hostfs_test_file.txt";
   Text : String := "Hello World in a file" & ASCII.LF;
   Read_Buffer : String (Text'Range);
   Read_Len    : Integer;
   Success     : Boolean;
begin

   --  Delete file
   Delete_File (Filename, Success);
   if not Success then
      Put_Line ("Cannot delete file");
   end if;

   --  Open file to write text
   File := Create_New_File (Filename, GNAT.OS_Lib.Text);
   if File = Invalid_FD then
      Put_Line ("Cannot create new file: " & Filename);
   else
      if Write (File, Text'Address, Text'Length) /= Text'Length then
         Put_Line ("Cannot write in file: " & Filename);
      end if;
      Close (File);
   end if;

   --  Open file to read text
   File := Open_Read (Filename, GNAT.OS_Lib.Text);
   if File = Invalid_FD then
      Put_Line ("Cannot open file: " & Filename);
   else
      Read_Len := Read (File, Read_Buffer'Address, Read_Buffer'Length);
      if Read_Len > 0 then
         Put_Line ("Read for file '" & Read_Buffer (1 .. Read_Len) & "'");
      end if;
      Close (File);
   end if;
end Main;
