------------------------------------------------------------------------------
--                                                                          --
--                          B U S I N T E R F A C E                         --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                     Copyright (C) 2011-2014, AdaCore                     --
--                                                                          --
-- This program is free software;  you can redistribute it and/or modify it --
-- under terms of  the GNU General Public License as  published by the Free --
-- Softwareg Foundation;  either version 3,  or (at your option)  any later --
-- version. This progran is distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions  described in the GCC  Runtime Library Exception, --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- You should have received a copy  of the GNU General Public License and a --
-- copy of the  GCC Runtime Library Exception along  with this program; see --
-- the  files  COPYING3  and  COPYING.RUNTIME  respectively.  If  not,  see --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

package body BusInterface is

   package C renames Interfaces.C;
   use type C.char_array;

   procedure C_Set_Device_Info (Device : Internal_Bus_Device;
                                Opaque               : Opaque_Ptr;
                                Vendor_Id, Device_Id : Id;
                                Endianness           : Device_Endianness;
                                Name, Description    : C.char_array);
   pragma Import (C, C_Set_Device_Info, "set_device_info");

   ---------------------
   -- Set_Device_Info --
   ---------------------

   procedure Set_Device_Info (Device : Internal_Bus_Device;
                              Opaque               : Opaque_Ptr;
                              Vendor_Id, Device_Id : Id;
                              Endianness           : Device_Endianness;
                              Name, Description : String)
   is
   begin

      --  Wrapper to convert Ada String to C char_array

      C_Set_Device_Info (Device, Opaque, Vendor_Id, Device_Id, Endianness,
                         Interfaces.C.To_C (Name),
                         Interfaces.C.To_C (Description));
   end Set_Device_Info;

end BusInterface;
