------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                    Copyright (C) 2013-2014, AdaCore                      --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with Bus_Devices; use Bus_Devices;
with Bus_Types;   use Bus_Types;

with UART_Controller; use UART_Controller;

package UART is

   ----------------
   -- The Device --
   ----------------

   type UART_Device (Vendor_Id, Device_Id : Id;
                     Base_Address         : Bus_Address;
                     Port                 : Integer)
      is new Bus_Device (Vendor_Id, Device_Id, Port, Native_Endian) with record

         UC : UART_Control;
   end record;

   type UART_Ref is access all UART_Device'Class;

   ----------------------
   -- Device callbacks --
   ----------------------

   overriding procedure IO_Read (Self    : in out UART_Device;
                                 Address : Bus_Address;
                                 Length  : Bus_Address;
                                 Value   : out Bus_Data);

   overriding procedure IO_Write (Self    : in out UART_Device;
                                  Address : Bus_Address;
                                  Length  : Bus_Address;
                                  Value   : Bus_Data);

   overriding procedure Device_Setup (Self : in out UART_Device);

   overriding procedure Device_Init (Self : in out UART_Device);

   overriding procedure Device_Reset (Self : in out UART_Device);

   overriding procedure Device_Exit (Self : in out UART_Device);

end UART;
