------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with Speed_Computation; use Speed_Computation;
with Ada.Real_Time;
with Target_Support.Interrupt; use Target_Support.Interrupt;

with IRQ_P;

procedure Computation_Loop is

   use type Ada.Real_Time.Time_Span;
   Offset_T1 : constant Ada.Real_Time.Time_Span
     := Ada.Real_Time.Seconds (1);
   Test_Period : constant Ada.Real_Time.Time_Span
     := Ada.Real_Time.MIlliseconds (1000);

   Speed  : Float;
   Error  : Boolean := False;
   Probes : Probe_Array;
   Next_Time : Ada.Real_Time.Time := Ada.Real_Time.Clock + Offset_T1;

begin

   Enable_External_Interrupt;

   loop
      Next_Time := Next_Time + Test_Period;
      delay until Next_Time;

      Read_Probes (Probes);
      Compute_Speed (Probes, Speed, Error);
      Write_Result (Speed, Error);
      Error := False;
   end loop;
end Computation_Loop;
