------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                     Copyright (C) 2011-2017, AdaCore                     --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;

package body Target_Support is
   procedure Halt is
      procedure OS_Exit;
      pragma Import (C, OS_Exit, "_exit");
   begin
      OS_Exit;
   end Halt;

   procedure New_Line renames Ada.Text_IO.New_Line;
   procedure Put (Item : Character) renames Ada.Text_IO.Put;
   procedure Put (Item : String) renames Ada.Text_IO.Put;
   procedure Put_Line (Item : String) renames Ada.Text_IO.Put_Line;
end Target_Support;
