------------------------------------------------------------------------------
--                                                                          --
--                               GNATemulator                               --
--                                                                          --
--                     Copyright (C) 2011-2017, AdaCore                     --
--                                                                          --
-- GNATemulator is free software; you can redistribute it  and/or modify it --
-- under terms of the GNU General Public License as published by the Free   --
-- Software Foundation; either version 2, or (at your option) any later     --
-- version. GNATemulator is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHAN-  --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with System.Machine_Code; use System.Machine_Code;

pragma Warnings (Off);
with GNAT.IO;
pragma Warnings (On);

package body Target_Support is
   procedure Halt is
   begin
      Asm ("mov 1, %%g1" & ASCII.LF & ASCII.HT & "ta 0",
           No_Output_Operands, No_Input_Operands, "g1", True);
   end Halt;

   procedure New_Line is
   begin
      Put_Line ("");
   end New_Line;

   procedure Put (Item : Character) renames GNAT.IO.Put;
   procedure Put (Item : String) renames GNAT.IO.Put;
   procedure Put_Line (Item : String) renames GNAT.IO.Put_Line;
end Target_Support;
