with GNAT.Decode_UTF8_String;
with Ada.Unchecked_Conversion;

package body Utils is

   function UTF16_Offset_To_UTF8_Offset
     (Str : String; Offset : Integer) return Integer
   is
      Ptr : Integer := 1;
   begin
      for J in 1 .. Offset loop
         GNAT.Decode_UTF8_String.Next_Wide_Character (Str, Ptr);
      end loop;

      return Ptr - 1;
   end UTF16_Offset_To_UTF8_Offset;

   function UTF8_Offset_To_UTF16_Offset
     (Str : String; Offset : Integer) return Integer
   is
      Ptr    : Integer := 1;
      Length : Integer := 1;
   begin
      while Ptr < Offset loop
         GNAT.Decode_UTF8_String.Next_Wide_Character (Str, Ptr);
         Length := Length + 1;
      end loop;

      return Length;
   end UTF8_Offset_To_UTF16_Offset;

   function Slide (Str : String; Start_Pos : Integer) return String is
   begin
      return Res : String (Start_Pos .. Start_Pos + Str'Length - 1) := Str;
   end Slide;

   function To_Filesystem_String
     (S : String_Access) return Filesystem_String_Access
   is
      function Conv is new Ada.Unchecked_Conversion
        (String_Access, Filesystem_String_Access);
   begin
    return Conv (S);
   end To_Filesystem_String;

end Utils;