with GNAT.Strings;
with GNATCOLL.VFS;

package GPS.Kernel.Properties is

   ----------------
   -- Properties --
   ----------------

   type Property_Record is abstract tagged null record;
   type Property_Access is access all Property_Record'Class;
   --  A general property that can be associated with a file.
   --  Such properties can be marked as persistent, that is they will exist
   --  from one session of GPS to the next, transparently.

   type String_Property is new Property_Record with record
      Value : GNAT.Strings.String_Access;
   end record;
   type String_Property_Access is access all String_Property'Class;


   procedure Set_Property
     (File       : GNATCOLL.VFS.Virtual_File;
      Name       : String;
      Property   : access Property_Record'Class;
      Persistent : Boolean := False);
   --  Associate a given property with File, so that it can be queries later
   --  through Get_File_Property.
   --  If Persistent is True, the property will be preserved from one session
   --  of GPS to the next.
   --  Property names are case sensitive.

   procedure Get_Property
     (Property : out Property_Record'Class;
      File     : GNATCOLL.VFS.Virtual_File;
      Name     : String;
      Found    : out Boolean);
   --  Return the given named property associated with File.
   --  Found is set to False if there is no such property.
   --  Property names are case sensitive.

   procedure Remove_Property
     (File     : GNATCOLL.VFS.Virtual_File;
      Name     : String);
   --  Remove the named property (persistent or not) from the file.

end GPS.Kernel.Properties;
