-----------------------------------------------------------------------
--                             GNATbench                             --
--                                                                   --
--                 Copyright (C) 2006-2009, AdaCore                  --
--                                                                   --
-----------------------------------------------------------------------

with GNAT.Strings; use GNAT.Strings;
with GNATCOLL.Filesystem; use GNATCOLL.Filesystem;

package GNAT.Expect.TTY.Remote is

   procedure Remote_Spawn
     (Descriptor          : out Process_Descriptor_Access;
      Target_Nickname     : String;
      Args                : GNAT.OS_Lib.Argument_List;
      Execution_Directory : Filesystem_String := "";
      Err_To_Out          : Boolean := False;
      On_New_Connection   : access procedure (Target_Name : String) := null);

   procedure Sync_Execute
     (Host                : String;
      Args                : GNAT.OS_Lib.Argument_List;
      Status              : out Boolean;
      Execution_Directory : Filesystem_String  := "");

   procedure Sync_Execute
     (Host                : String;
      Args                : GNAT.OS_Lib.Argument_List;
      Out_Value           : out GNAT.Strings.String_Access;
      Status              : out Boolean;
      Execution_Directory : Filesystem_String  := "");

end GNAT.Expect.TTY.Remote;
