#!/bin/sh

# Imports the minimal set of sources needed for a public packaging of 
# GPS & GNAT for the library.

# This script requires to be set:
# TARGET_PATH -> Where to put gps & gnat
# GPS_SRC_BASE -> base of GPS source files
# GNAT_SRC_BASE -> base of GNAT source files

cd $GPS_SRC_BASE

files="ada_module/src/*ad? common/src/*ad? kernel/src_info/*ad? \
       completion/src/*ad? codefix/src/*ad? \
       gnat/*ad? gnatlib/src/*ad? gnatlib/src/*.c"

mkdir -p $TARGET_PATH/gps_library/gps_sources

tar cf - $files | (cd $TARGET_PATH/gps_library/gps_sources ; tar xf -)

cp Makefile.gnat $TARGET_PATH/gps_library/gps_sources

