with Ragged_Strings;
with Ada.Containers.Vectors;
with GNAT.OS_Lib; use GNAT.OS_Lib;

package Scenario_Variables is

   type Setting is
      record
         Name  : String_Access;
         Value : String_Access;
      end record;

   package Settings is
      new Ada.Containers.Vectors (Natural, Setting);
   use Settings;

   --  returns all those scenario var settings from the .gb_project file
   function From_File return Settings.Vector;

   --  converts a vector of settings into a vector of strings, where
   --  each string is of the form -Xname=value
   function As_Switches (Vars : Settings.Vector) return Ragged_Strings.Vector;

end Scenario_Variables;
