with Ada.Text_IO;  use Ada.Text_IO;
with Ada.Strings.Fixed;  use Ada.Strings.Fixed;
with Ada.Strings.Maps.Constants;  use Ada.Strings.Maps;

package body Scenario_Variables is

   Project_File_Name : constant String := ".gb_project";

   Scenario_Element_Begin : constant String := "<Scenarios>";
   Scenario_Element_End   : constant String := "</Scenarios>";

   -----------------
   -- As_Switches --
   -----------------

   function As_Switches (Vars : Settings.Vector) return Ragged_Strings.Vector is
      Result   : Ragged_Strings.Vector := Ragged_Strings.Empty_Vector;
      C        : Cursor;
      Scenario : Setting;
      New_Arg  : String_Access;
   begin
      C := Vars.First;
      while Has_Element (C) loop
         Scenario := Element (C);
         New_Arg := new String'("-X" & Scenario.Name.all & "=" & Scenario.Value.all);
         Result.Append (New_Arg);
         Next (C);
      end loop;
      return Result;
   end As_Switches;

   ---------------
   -- From_File --
   ---------------

   function From_File return Settings.Vector is
      GPR             : File_Type;
      Content         : String_Access;
      Scenarios_Start : Natural;
      Scenarios_End   : Natural;
      Result          : Vector;

      First     : Natural;
      Last      : Natural;
      Delimiter : constant Character_Set := not To_Set (Sequence => ('<','>'));

      Name      : String_Access;
      Value     : String_Access;
   begin
      Open (GPR, In_File, Project_File_Name);
      Content := new String'(Get_Line (GPR));
      Close (GPR);

      Scenarios_Start := Index (Content.all, Scenario_Element_Begin);
      if Scenarios_Start = 0 then
         return Empty_Vector;
      end if;

      Scenarios_End := Index (Content.all, Scenario_Element_End);

      First := Scenarios_Start + Scenario_Element_Begin'Length;
      Last := Scenarios_End;

      loop
         Find_Token (Content (First .. Last),
                     Delimiter, Ada.Strings.Inside, First, Last);
         exit when Last = 0;

         Name := new String'(Content (First .. Last));

         First := Last + 1;
         Last := Scenarios_End;

         Find_Token (Content (First .. Last),
                     Delimiter, Ada.Strings.Inside, First, Last);
         exit when Last = 0;

         Value := new String'(Content (First .. Last));

         Result.Append (Setting'(Name, Value));

         --  skip /name
         First := Index (Content (Last + 1 .. Scenarios_End), Name.all);
         First := First + Name'Length;

         Last := Scenarios_End;
      end loop;

      return Result;
   exception
      when Name_Error =>
         Put_Line (Standard_Error,
            "Could not open project file " & Project_File_Name);
         return Empty_Vector;
   end From_File;

end Scenario_Variables;
