with GNAT.OS_Lib;  use GNAT.OS_Lib;
with Ada.Containers.Vectors;

package Known_Build_Specs is

   --  The mapping file has two fields per line, separated by one or more
   --  contiguous horizontal tab characters.

   --  The two fields are the regex pattern and the tool name prefix, in that
   --  order.

   --  For example, a complete file could look as follows, in which there are a
   --  total of four pattern::tool-name mappings:

   --  ^PPC[0-9]+gnu		powerpc-wrs-vxworks
   --  ^PENTIUM[0-9]gnu		i586-wrs-vxworks
   --  ^SIMPENTIUMgnu_RTP	i586-wrs-vxworks
   --  ^SIMNTgnu		i586-wrs-vxworks

   Map_File_Name : constant String := "gnatwrapper_build_specs";

   type Descriptor is
      record
         Pattern : String_Access;
         Prefix  : String_Access;
      end record;

   package Mapping is
      new Ada.Containers.Vectors (Positive, Descriptor);
   use Mapping;

   --  Read the mapping file and return a vector of descriptors.
   --  If there is any problem whatsoever, returns an empty vector.
   function Map return Vector;

end Known_Build_Specs;
