with Build_Specs;   use Build_Specs;
with System.OS_Lib; use System.OS_Lib;

package Gnatwrapper_Utils is

   --  Runs "<cross-compiler-name>-gnatls -v" to get the version of GNAT
   --  installed, to determine if we can use the -eS switch.
   --  The first entry in Gnatls_Invocation is the name of "gnatls" that is
   --  specific to the compiler installed: it might be:
   --     powerpc-wrs-vxworks-gnatls
   --  or
   --     i586--wrs-vxworks-gnatls
   --  depending on the build spec pass to gnatwrapper.
   procedure Get_GNAT_Version
     (Gnatls_Name  : in  String_Access;
      GNAT_Version : out String_Access);


   --  Correct the extension returned from the project facility.
   --  Necessary since the project facility appends the extension of the
   --  host compiler (if any), instead of the cross compiler.
   --  If Executable_Suffix *is* defined in the project file the project
   --  facility does use it, but that attribute is optional.

   procedure Correct_Executable_File_Name
      (File_Name         : in out String_Access;
       Executable_Suffix : in     String_Access;
       Spec              : in     Build_Spec);


   --  runs the command. exits the app with an error code
   --  if unsuccessful.
   procedure Launch (Command_With_Path : in String_Access;
                     Args              : in String_List);


   --  Strip all carriage returns from the input string
   function Strip_CR (Text : String) return String;

end Gnatwrapper_Utils;
