-----------------------------------------------------------------------
--                             GNATbench                             --
--                                                                   --
--                 Copyright (C) 2006-2009, AdaCore                  --
--                                                                   --
-----------------------------------------------------------------------

with Scenario_Variables;
with Projects.Registry;  use Projects.Registry;
with GNAT.OS_Lib;        use GNAT.OS_Lib;

package GNAT_Project is

   type File is tagged private;

   procedure Initialize (This : in out File; GPR_File_Name : String);

   function Name (This : File) return String_Access;

   --  apply all These scenario variable settings to the project
   procedure Apply
      (This  : in out File;
       These :        Scenario_Variables.Settings.Vector);

   --  Get the name of the executable file and the name of the main program
   --  from the project.  If the gnatwrapper invocation specifies the main
   --  unit (via the -m switch) Selected_Main_Name will not be null when
   --  this routine is invoked, and Get_Exe will verify that it is a main
   --  specified in the project.  Otherwise there must be only one main unit
   --  specified by the project, and if so, Selected_Main_Name will be set
   --  accordingly.  The value of Executable_File_Name is set to the name,
   --  including full path, for the executable generated for the given main
   --  unit.
   procedure Get_Exe
      (This                 : in out File;
       Executable_File_Name :    out String_Access;
       Selected_Main_Name   : in out String_Access);

   --  Get the value of the executable_suffix attribute if it is specified
   --  in the project file.  Sets Executable_Suffix to null if not specified.
   procedure Get_Exe_Suffix
      (This   : in out File;
       Suffix :    out String_Access);

private

   type File is tagged record
      Registry  : Project_Registry;
      File_Name : String_Access;
   end record;

end GNAT_Project;
