with System.OS_Lib;  use System.OS_Lib;

package Build_Specs is

   type Build_Spec is tagged private;

   procedure Initialize (This: in out Build_Spec;  Name : in String);

   function Name (This : Build_Spec) return String_Access;

   function Is_RTP (This : Build_Spec) return Boolean;

   function Gnatmake_Name (This : Build_Spec) return String_Access;

   function Gnatclean_Name (This : Build_Spec) return String_Access;

   function Gnatls_Name (This : Build_Spec) return String_Access;

   function Executable_File_Extension (This : Build_Spec) return String;

private

   type Build_Spec is tagged record
      Name      : String_Access;
      Is_RTP    : Boolean;
      Gnatmake  : String_Access;
      Gnatclean : String_Access;
      Gnatls    : String_Access;
   end record;

end Build_Specs;

