-----------------------------------------------------------------------
--                             GNATbench                             --
--                                                                   --
--                 Copyright (C) 2006-2009, AdaCore                  --
--                                                                   --
-----------------------------------------------------------------------

with AJIS.Annotations; use AJIS.Annotations;

with GNAT.Strings; use GNAT.Strings;
with Codefix; use Codefix;
with Codefix.Text_Manager; use Codefix.Text_Manager;
with Language; use Language;

with Case_Handling;
with GNATCOLL.VFS; use GNATCOLL.VFS;
with GNATCOLL.Filesystem; use GNATCOLL.Filesystem;
with Projects; use Projects;
with Projects.Registry; use Projects.Registry;
with Namet; use Namet;
with Glib; use Glib;
with Language_Handlers; use Language_Handlers;
with Projects.Editor; use Projects.Editor;
with Language.Ada; use Language.Ada;
with Output;
with Prj;
with Prj.PP;
with GNAT.Expect;

package Binding_Config is

   procedure Assign_String
     (This : in out String_Access; Value : String)
      renames Codefix.Assign;
   pragma Annotate (AJIS, Annotation_Renaming, Assign_String);
   pragma Annotate (AJIS, Rename, Assign_String, "Assign_String");

   procedure Assign_String_Access
     (This : in out String_Access; Value : String_Access)
      renames Codefix.Assign;
   pragma Annotate (AJIS, Annotation_Renaming, Assign_String_Access);
   pragma Annotate
     (AJIS, Rename, Assign_String_Access, "Assign_String_Access");

   function Keywords_String
     (Lang : access Language_Root) return String_Access
      renames Language.Keywords;
   pragma Annotate (AJIS, Annotation_Renaming, Keywords_String);
   pragma Annotate (AJIS, Rename, Keywords_String, "Keywords_String");

   function Keywords_Pattern
     (Lang : access Language_Root) return GNAT.Expect.Pattern_Matcher_Access
      renames Language.Keywords;
   pragma Annotate (AJIS, Annotation_Renaming, Keywords_Pattern);
   pragma Annotate (AJIS, Rename, Keywords_Pattern, "Keywords_Pattern");

   function Keywords_String
     (Lang : access Ada_Language) return String_Access
      renames Language.Ada.Keywords;
   pragma Annotate (AJIS, Annotation_Renaming, Keywords_String);
   pragma Annotate (AJIS, Rename, Keywords_String, "Keywords_String");

   function Keywords_Pattern
     (Lang : access Ada_Language) return GNAT.Expect.Pattern_Matcher_Access
      renames Language.Ada.Keywords;
   pragma Annotate (AJIS, Annotation_Renaming, Keywords_Pattern);
   pragma Annotate (AJIS, Rename, Keywords_Pattern, "Keywords_Pattern");

   function Get_Project_From_File_VFS
     (Registry          : Project_Registry;
      Source_Filename   : GNATCOLL.VFS.Virtual_File;
      Root_If_Not_Found : Boolean := True)
      return Project_Type renames Projects.Registry.Get_Project_From_File;
   pragma Annotate (AJIS, Annotation_Renaming, Get_Project_From_File_VFS);
   pragma Annotate
     (AJIS, Rename, Get_Project_From_File_VFS, "Get_Project_From_File_VFS");

   function Get_Project_From_File_String
     (Registry          : Project_Registry;
      Base_Name         : Filesystem_String;
      Root_If_Not_Found : Boolean := True)
      return Project_Type renames Projects.Registry.Get_Project_From_File;
   pragma Annotate (AJIS, Annotation_Renaming, Get_Project_From_File_String);
   pragma Annotate
     (AJIS, Rename, Get_Project_From_File_VFS, "Get_Project_From_File_String");

   procedure Get_Name_String_Void
     (Id : Name_Id)
      renames Namet.Get_Name_String;
   pragma Annotate (AJIS, Annotation_Renaming, Get_Name_String_Void);
   pragma Annotate
     (AJIS, Rename, Get_Name_String_Void, "Get_Name_String_Void");

   function Project_Name_String
     (Project : Project_Type) return String
      renames Projects.Project_Name;
   pragma Annotate (AJIS, Annotation_Renaming, Project_Name_String);
   pragma Annotate (AJIS, Rename, Project_Name_String, "Project_Name_String");

   function Project_Name_Id
     (Project : Project_Type) return Namet.Name_Id
      renames Projects.Project_Name;
   pragma Annotate (AJIS, Annotation_Renaming, Project_Name_Id);
   pragma Annotate (AJIS, Rename, Project_Name_Id, "Project_Name_Id");

   function Get_Language_From_File_Language
     (Handler           : access Language_Handlers.Language_Handler_Record;
      Source_Filename   : GNATCOLL.VFS.Virtual_File;
      From_Project_Only : Boolean := False) return Language.Language_Access
      renames Language_Handlers.Get_Language_From_File;
   pragma Annotate
     (AJIS, Annotation_Renaming, Get_Language_From_File_Language);
   pragma Annotate
     (AJIS, Rename, Get_Language_From_File_Language,
      "Get_Language_From_File_Language");

   function Get_String_Name_Id
     (Id : Namet.Name_Id) return String
      renames Projects.Get_String;
   pragma Annotate (AJIS, Annotation_Renaming, Get_String_Name_Id);
   pragma Annotate (AJIS, Rename, Get_String_Name_Id, "Get_String_Name_Id");

   function Get_String_File_Name_Type
     (Id : Namet.File_Name_Type) return String
      renames Projects.Get_String;
   pragma Annotate (AJIS, Annotation_Renaming, Get_String_File_Name_Type);
   pragma Annotate
     (AJIS, Rename, Get_String_File_Name_Type, "Get_String_File_Name_Type");

   function Get_String_Path_Name_Type
     (Id : Namet.Path_Name_Type) return String
      renames Projects.Get_String;
   pragma Annotate (AJIS, Annotation_Renaming, Get_String_Path_Name_Type);
   pragma Annotate
     (AJIS, Rename, Get_String_Path_Name_Type, "Get_String_Path_Name_Type");

   function Get_String_Unit_Name_Type
     (Id : Namet.Unit_Name_Type) return String
      renames Projects.Get_String;
   pragma Annotate (AJIS, Annotation_Renaming, Get_String_Unit_Name_Type);
   pragma Annotate
     (AJIS, Rename, Get_String_Unit_Name_Type, "Get_String_Unit_Name_Type");

   function Get_String_Name_Id
     (Str : String) return Namet.Name_Id
      renames Projects.Editor.Get_String;
   pragma Annotate (AJIS, Annotation_Renaming, Get_String_Name_Id);
   pragma Annotate (AJIS, Rename, Get_String_Name_Id, "Get_String_Name_Id");

   function Get_String_Name_Type
     (Str : String) return Namet.File_Name_Type
      renames Projects.Editor.Get_String;
   pragma Annotate (AJIS, Annotation_Renaming, Get_String_Name_Type);
   pragma Annotate
     (AJIS, Rename, Get_String_Name_Type, "Get_String_Name_Type");

   function Get_String_Path_Name_Type
     (Str : String) return Namet.Path_Name_Type
      renames Projects.Editor.Get_String;
   pragma Annotate (AJIS, Annotation_Renaming, Get_String_Path_Name_Type);
   pragma Annotate
     (AJIS, Rename, Get_String_Path_Name_Type, "Get_String_Path_Name_Type");

   procedure Load
     (Registry           : in out Project_Registry;
      Root_Project_Path  : GNATCOLL.VFS.Virtual_File;
      Errors             : Projects.Error_Report;
      New_Project_Loaded : out Boolean;
      Status             : out Boolean)
      renames Projects.Registry.Load;
   pragma Annotate (AJIS, Annotation_Renaming, Load);
   pragma Annotate (AJIS, Assume_Escaped, False, Load, "Errors");

   procedure Reload_If_Needed
     (Registry : in out Project_Registry;
      Errors   : Projects.Error_Report;
      Reloaded : out Boolean) renames Projects.Registry.Reload_If_Needed;
   pragma Annotate (AJIS, Annotation_Renaming, Reload_If_Needed);
   pragma Annotate (AJIS, Assume_Escaped, False, Reload_If_Needed, "Errors");

   procedure Recompute_View
     (Registry : in out Project_Registry;
      Errors   : Projects.Error_Report)
      renames Projects.Registry.Recompute_View;
   pragma Annotate (AJIS, Annotation_Renaming, Recompute_View);
   pragma Annotate (AJIS, Assume_Escaped, False, Recompute_View, "Errors");

   procedure Format_Buffer
     (Lang                : access Language_Root;
      Buffer              : String;
      Replace             : Replace_Text_Callback;
      From, To            : Natural := 0;
      Indent_Params       : Indent_Parameters := Default_Indent_Parameters;
      Indent_Offset       : Natural := 0;
      Case_Exceptions     : Case_Handling.Casing_Exceptions :=
        Case_Handling.No_Casing_Exception;
      Is_Optional_Keyword : access function (S : String)
      return Boolean := null) renames Language.Format_Buffer;
   pragma Annotate (AJIS, Annotation_Renaming, Format_Buffer);
   pragma Annotate (AJIS, Assume_Escaped, False, Format_Buffer, "Replace");

   procedure Rename_And_Move
     (Root_Project  : Project_Type;
      Project       : Project_Type;
      New_Name      : Filesystem_String;
      New_Path      : GNATCOLL.VFS.Virtual_File;
      Report_Errors : Output.Output_Proc := null)
      renames Projects.Editor.Rename_And_Move;
   pragma Annotate (AJIS, Annotation_Renaming, Rename_And_Move);
   pragma Annotate
     (AJIS, Assume_Escaped, False, Rename_And_Move, "Report_Errors");

   procedure Pretty_Print
     (Project              : Project_Type;
      Increment            : Positive             := 3;
      Minimize_Empty_Lines : Boolean              := False;
      W_Char               : Prj.PP.Write_Char_Ap := null;
      W_Eol                : Prj.PP.Write_Eol_Ap  := null;
      W_Str                : Prj.PP.Write_Str_Ap  := null)
      renames Projects.Registry.Pretty_Print;
   pragma Annotate (AJIS, Annotation_Renaming, Pretty_Print);
   pragma Annotate
     (AJIS, Assume_Escaped, False, Pretty_Print, "W_Char");
   pragma Annotate
     (AJIS, Assume_Escaped, False, Pretty_Print, "W_Eol");
   pragma Annotate
     (AJIS, Assume_Escaped, False, Pretty_Print, "W_Str");

end Binding_Config;
