#!/bin/sh

if [ "$GPS_SRC_BASE" = "" ]; then
   GPS_SRC_BASE=../gps
fi

export GPS_SRC_BASE

file_list=""

for f in `cat Manifest.binding`; do
   file_list="$file_list $GPS_SRC_BASE/$f"
done

file_list="$file_list utils.ads"

echo "$file_list"

rm -rf binding/*

ada2java -P gnatbench_dll.gpr \
 -b com.adacore.gnatbench.library -o binding/ada -c binding \
 --assume-escaped \
 --locking-check \
 --locking-finalize-protect \
 --attach-parameter \
 --lock=com.adacore.gnatbench.library.LibrarySemaphore.fgLock \
 --no-java-enum \
 binding_config.ads $file_list
