#!/bin/sh

clear
cat <<EOF

  This script is provided to simplify the installation of GNATbench,
  the GNAT Plugin for Eclipse.

  You will be asked for confirmation before the actual installation is
  done. You can break out of this script at any time before this.

  Hit RETURN to continue.
EOF

read x

current_dir=`/bin/pwd`
plugins_dirs="plugins"
features_dirs="features"

   #########################
   # check_eclipse_version #
   #########################

check_eclipse_version(){
   eclipse=$1

   if [ "$eclipse" != "" ]; then
      eclipse="${eclipse}/"
   fi

   # ??? Check the actual version of eclipse here
   # ??? Check the actual version of CDT here

   if [ ! -f "${eclipse}eclipse" ]; then
      echo ""
      echo "No eclipse install found at $eclipse"
      echo ""
      exit 1
   fi
}

   ###############
   # ask_gnatdir #
   ###############

## Read the base directory (absolute path name)
## Sets the variable  $basedir
ask_gnatdir() {
   clear
   default_dir=`(type gnat | cut -d' ' -f3) 2>/dev/null`
   default_dir=`dirname $default_dir 2>/dev/null`

   if [ "$default_dir" != "" -a "$default_dir" != "." -a "$default_dir" != "/usr/bin" ]; then
      default_dir=`cd $default_dir/..; pwd`

      cat <<EOF

  GNAT has been found in $default_dir.
  Do you want to use this GNAT installation? Hit RETURN if yes or enter
  the name of another directory.

EOF
   else
     default_dir=/opt/gnat
     cat <<EOF
  Enter the full path of a GNAT installation.

EOF
   fi

   while [ "$basedir " = " " ]; do
      printf "[$default_dir] "
      read basedir

      if [ " $basedir" = " " ]; then
         basedir="$default_dir"
      fi

      if echo $basedir | egrep "^[/~]" >/dev/null; then
         true
      else
         basedir=`pwd`/$basedir
      fi
   done

   # Suppress the final / in basedir
   basedir=`echo $basedir | sed -e 's/\/$//'`

   # Check that we have permission to write in $basedir
   if test -d $basedir; then
     if test -w $basedir; then
        if [ -x $basedir/eclipse ]; then
           echo "  $basedir/eclipse found."
           printf "  Do you want to overwrite existing installation [Y/n] ? "
           read x
           if [ " $x" = " n" -o " $x" = " N" ]; then
              echo "Aborting the installation process"
	      exit 1
           fi
        fi
     else
        echo "You do not have permission to write in $basedir"
        echo "Please check that you have the appropriate privileges to"
        echo "install in that directory."
        echo "Aborting the installation process"
        exit 1
     fi
   else
     echo ""
     echo "  Directory $basedir does not exist."
     printf "  Do you want to create it [Y/n] ? "
     read x
     if [ " $x" = " n" -o " $x" = " N" ]; then
        echo "Aborting the installation process"
	exit 1
     fi
     mkdir -p $basedir
   fi
}

   ##################
   # check_linkpath #
   ##################

check_linkpath() {
  # Suppress the final / in basedir
   linkpath=`echo $linkpath | sed -e 's/\/$//'`

   # Check that we have permission to write in $basedir
   if test -d $linkpath; then
     if test -w $linkpath; then
        if [ -x $linkpath/gnatbench.link ]; then
           echo " "
           echo " gnatbench.link found."
           echo " "
           printf "  Do you want to overwrite existing installation [Y/n] ? "
           read x
           if [ " $x" = " n" -o " $x" = " N" ]; then
              echo "Aborting the installation process"
	      exit 1
           fi
        fi
     else
        echo "You do not have permission to write in $linkpath"
        echo "Please check that you have the appropriate privileges to"
        echo "install in that directory."
        echo "Aborting the installation process"
        exit 1
     fi
   fi

   echo ""
   printf "  Are you now ready to proceed with the installation [Y/n] ? "
   read x
   if [ " $x" = " n" -o " $x" = " N" ]; then
      echo "Aborting the installation process"
      exit 1
   fi
}

   ##################
   # ask_eclipsedir #
   ##################

ask_eclipsedir() {
   clear

   default_dir=`(type eclipse | cut -d' ' -f3) 2>/dev/null`
   default_dir=`dirname $default_dir 2>/dev/null`

   if [ "$default_dir" != "" -a "$default_dir" != "." -a "$default_dir" != "/usr/bin" ]; then
      cat <<EOF

  Eclipse has been found in $default_dir.
  Do you want to use this Eclipse installation? Hit RETURN if yes or enter
  the name of another directory where Eclipse is installed.

EOF
   else
     cat <<EOF
  Enter the full path of an Eclipse installation

EOF
   fi

   while [ "$eclipsedir" = "" ]; do
      printf "[$default_dir] "
      read eclipsedir

      if [ "$eclipsedir" = "" ]; then
         eclipsedir="$default_dir"
      fi

      check_eclipse_version $eclipsedir

      linkpath="$eclipsedir/links"

      if [ ! -d $linkpath ]; then
      	mkdir $linkpath
      fi
   done
}

   #############
   # ask_wrdir #
   #############

## Read the windriver directory (absolute path name)
## Sets the variable  $linkpath
ask_wrdir() {
   clear

   cat <<EOF

  Enter the name of the directory of your WindRiver workbench base installation

EOF

   default_dir=""

   while [ "$wrdir " = " " ]; do
      printf "> "
      read wrdir
      if [ " $wrdir" = " " ]; then
         wrdir="$default_dir"
      fi

      for directory in $wrdir/workbench-*; do
         if [ "$directory" != "$wrdir/workbench-*" ]; then
            linkpath="$directory/wrwb/platform/eclipse/links"
            echo "Workbench >= 2.5 found"
         fi
      done

      if [ " $linkpath" = " " ]; then
         cat <<EOF
  The directory you specified does not contains a version of workbench > 2.5/
EOF

         wrdir=""
      fi
   done

   # Suppress the final / in basedir
   linkpath=`echo $linkpath | sed -e 's/\/$//'`

   # Check that we have permission to write in $basedir
   if test -d $linkpath; then
     if test -w $linkpath; then
        if [ -x $linkpath/gnatbench.link ]; then
           echo " "
           echo " gnatbench.link found."
           echo " "
           printf "  Do you want to overwrite existing installation [Y/n] ? "
           read x
           if [ " $x" = " n" -o " $x" = " N" ]; then
              echo "Aborting the installation process"
	      exit 1
           fi
        fi
     else
        echo "You do not have permission to write in $linkpath"
        echo "Please check that you have the appropriate privileges to"
        echo "install in that directory."
        echo "Aborting the installation process"
        exit 1
     fi
   fi
}

##################################
## Do the actual installation
##################################

install_binaries() {

  echo "Installing the binaries ...."

  cd "$basedir"

  os=`uname -s`
  cpu=`uname -p`
  
  case $cpu in
     unknown)
        cpu=`uname -m`
        ;;
     *)
        ;;
  esac

  # Copy the gnatwrapper program

  if [ "$INSTALL_TYPE" = "workbench" ]; then
    case $cpu-$os in
     sparc-SunOS ) gw=$current_dir/bin/sparc-solaris/gnatwrapper ;;
     i?86-Linux   ) gw=$current_dir/bin/x86-linux/gnatwrapper ;;
     x86_64-Linux ) gw=$current_dir/bin/x86_64-linux/gnatwrapper ;;
     * ) gw=$current_dir/bin/x86-windows/gnatwrapper.exe ;;
    esac

    mkdir -p $basedir/bin/
    cp $gw $basedir/bin/
  fi

  # Create the directories

  if [ ! -d eclipse/ ]; then
     mkdir eclipse
  fi

  # Copy the plugins and features

  if [ ! -d eclipse/plugins/ ]; then
     mkdir eclipse/plugins/
  fi

  if [ ! -d eclipse/features/ ]; then
     mkdir eclipse/features/
  fi

  for i in $plugins_dirs; do
     (cd "$current_dir"

      for plugin in ` ls $i | grep -v library `
      do
         cp -r $i/$plugin $basedir/eclipse/plugins
      done

      case $cpu-$os in
        sparc-SunOS )
          cp -r $i/com.adacore.gnatbench.library.solaris.sparc* $basedir/eclipse/plugins
          ;;
        i?86-Linux   )
          cp -r $i/com.adacore.gnatbench.library.linux.x86_?.* $basedir/eclipse/plugins
          ;;
        x86_64-Linux )
          cp -r $i/com.adacore.gnatbench.library.linux.x86_64_?.* $basedir/eclipse/plugins
          ;;
        * )
          cp -r $i/com.adacore.gnatbench.library.win32* $basedir/eclipse/plugins
          ;;
      esac
     )
  done

  for i in $features_dirs; do
     (cd "$current_dir"; cp -r $i/* $basedir/eclipse/features)
  done

  echo "path=$basedir" > "$linkpath/gnatbench.link"
}

##
##  Write the end message
##
end_message() {
   #clear
   cat <<EOF

   GNATbench has now been installed on your machine.

   Make sure that GNATbench tools are on your path by typing one of the
   following commands:

   for csh and tcsh shells:
      setenv PATH $basedir/bin:\$PATH
   for sh, bash, ksh and zsh:
      PATH=$basedir/bin:\$PATH
      export PATH

EOF
}

## Main program

ask_gnatdir

if [ "$INSTALL_TYPE" = "eclipse" ]; then
    ask_eclipsedir
elif [ "$INSTALL_TYPE" = "workbench" ]; then
    ask_wrdir
fi

check_linkpath
install_binaries
end_message
