package com.adacore.gnatbench.windriver.internal.wizards.newProject;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import com.windriver.ide.ui.project.wizards.WRDownloadAbleModuleProjectWizard;


public class NewDownloadableModuleProjectAction extends Action {

    private IWorkbenchWindow window;

    public NewDownloadableModuleProjectAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    } // NewDownloadableModuleProjectAction

    public NewDownloadableModuleProjectAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        } // if
        this.window = window;
    } // NewDownloadableModuleProjectAction


    public void run() {
		WRDownloadAbleModuleProjectWizard wizard = new WRDownloadAbleModuleProjectWizard();

		IWorkbench workbench = PlatformUI.getWorkbench();

		ISelection selection = window.getSelectionService().getSelection();

		IStructuredSelection selectionToPass = StructuredSelection.EMPTY;
		if (selection instanceof IStructuredSelection)
			selectionToPass = (IStructuredSelection) selection;
		wizard.init(workbench, selectionToPass);

		wizard.setForcePreviousAndNextButtons(true);

		WizardDialog dialog = new WizardDialog(null, wizard);
		dialog.create();
		dialog.open();
	} // run
    
} // NewDownloadableModuleProjectAction
