/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.windriver.internal.wizards.newProject;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.PlatformUI;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class NewAdaKernelModuleProject extends AbstractNewAdaProject  {

	protected IProject getNewProject() {
		NewProjectListener listener = new NewProjectListener();
		ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, IResourceChangeEvent.POST_CHANGE);
		(new NewDownloadableModuleProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow())).run();
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
		IProject project = listener.getNewProject();
		return project;
	} // getNewProject


	protected boolean createGPRfile(String projectName, String mainUnitName) {
		String projFileName = new String (projectName + ".gpr");
		IFile file = newProject.getFile(new Path (projFileName));

		if (!file.exists()) {
			String newGPRfile =
				"project " + projectName + " is\n" +
				"\n" +
				"\ttype Mode_Type is (\"Production\", \"Debug\");\n" +
			    "\tMode : Mode_Type := external (\"BUILD\", \"Debug\");\n" +
				"\n" +
				"\tfor Main use (\"" + mainUnitName + ".adb\");\n"+
				"\n" +
				"\tcase Mode is\n"+
				"\t\twhen \"Debug\" =>\n"+
				"\t\t\tfor Object_Dir use \"debug_objs\";\n"+
				"\t\twhen \"Production\" =>\n"+
				"\t\t\tfor Object_Dir use \"production_objs\";\n"+
				"\tend case;\n"+
				"\n" +
				"\tpackage Compiler is\n" +
				"\t\tcase Mode is\n" +
				"\t\t\twhen \"Debug\" =>\n" +
				"\t\t\t\tfor Default_Switches (\"Ada\") use\n" +
				"\t\t\t\t\t\t(\"-g\", \"-gnato\", \"-fstack-check\");\n" +
				"\t\t\twhen \"Production\" =>\n" +
				"\t\t\t\tfor Default_Switches (\"Ada\") use (\"-O2\");\n" +
				"\t\tend case;\n" +
				"\tend Compiler;\n" +
				"\n" +
				"\tDKM_Switches := (\"--RTS=kernel\");\n" +
				"\n" +
				"\tpackage Builder is\n" +
				"\t\tcase Mode is\n" +
				"\t\t\twhen \"Debug\" =>\n" +
				"\t\t\t\tfor Default_Switches (\"Ada\") use\n" +
				"\t\t\t\t\t\tDKM_Switches & (\"-g\");\n" +
				"\t\t\twhen \"Production\" =>\n" +
				"\t\t\t\tnull;\n" +
				"\t\tend case;\n" +
				"\tend Builder;\n" +
				"\n" +
				"end " + projectName + ";";

			try {
				file.create(new ByteArrayInputStream(newGPRfile.getBytes()),
						true, null);
			} catch (CoreException e) {
				displayError("Create GNAT project",
						"Adding project file '" + projFileName +
						"' to project " + projectName + " failed");
				GNATbenchCorePlugin.getDefault().logError(null, e);
				return false;
			} // try
		} // if
		return true;
	} // createGPRfile


} // NewAdaKernelModuleProject
