package com.adacore.gnatbench.windriver.internal.wizards.newProject;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.adacore.gnatbench.core.internal.utils.SyntaxUtils;

public class AdaMainPage extends WizardPage {
	
    protected Text unitNameWidget;
	protected String fmainUnitName = new String("");
	protected Button fCreateMainProgramFile;
	
	
	public AdaMainPage(String pageName) {
		super (pageName);
		this.setTitle(pageName);
		this.setDescription("Specify the name of the Ada main procedure " +
				            " (not the file name) and whether " +
				            "you want to have the corresponding file generated" +
				            " automatically.");
	} // AdaMainPage
	
	
	public boolean createFile() {
		return fCreateMainProgramFile.getSelection();
	} // createFile
	
	
	public String unitName() {
		return fmainUnitName.trim();
	} // unitName
	
	
    public boolean isPageComplete() {
    	return (isCurrentPage() && SyntaxUtils.isAdaIdentifier(fmainUnitName.trim()));
    } // isPageComplete
	

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            unitNameWidget.setFocus();
        } // if
    } // SetVisible
    
    
	public void createControl(Composite parent) {
		Composite baseComp = new Composite(parent, SWT.NONE);
		setControl(baseComp);

		GridLayout topLayout = new GridLayout();
		baseComp.setLayout(topLayout);

		Composite locationComp = new Composite(baseComp, SWT.NONE);
		GridLayout locationLayout = new GridLayout();
		locationLayout.numColumns = 2;
		locationLayout.marginHeight = 1;
		locationLayout.marginWidth = 1;
		locationComp.setLayout(locationLayout);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		locationComp.setLayoutData(gd);

		Label label = new Label(locationComp, SWT.NONE);
		label.setText("Name of the Ada main subprogram:");
		gd = new GridData();
		gd.horizontalSpan = 2;
		label.setLayoutData(gd);

		unitNameWidget = new Text(locationComp, SWT.SINGLE | SWT.BORDER);
		
		unitNameWidget.addModifyListener(new ModifyListener () {

			public void modifyText(ModifyEvent e) {
				fmainUnitName = new String (((Text) e.getSource()).getText());
		        if (isCurrentPage()) {
		            getContainer().updateButtons();
		        } // if
			}});
		
		gd = new GridData(GridData.FILL_HORIZONTAL);
		unitNameWidget.setLayoutData(gd);
		
		Composite projectComp = new Composite(baseComp, SWT.NONE);
		GridLayout projectLayout = new GridLayout();
		projectLayout.numColumns = 2;
		projectLayout.marginHeight = 0;
		projectLayout.marginWidth = 0;
		projectComp.setLayout(projectLayout);
		projectComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		fCreateMainProgramFile = new Button (projectComp, SWT.CHECK);
		fCreateMainProgramFile.setText("Generate Ada main program file");
		fCreateMainProgramFile.setSelection(true);
		gd = new GridData();
		gd.horizontalSpan = 2;
		fCreateMainProgramFile.setLayoutData(gd);		
	} // createControl
	

} // AdaMainPage
