/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.windriver.internal;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.GNATbenchProjectProperties;
import com.adacore.gnatbench.core.internal.builder.GNATbenchProjectNature;
import com.adacore.gnatbench.core.projects.IGNATProjectRegistry;

public class GPRSpy implements IResourceChangeListener, IResourceDeltaVisitor {

	static int fConversionPolicy;

	static final int YES = 0;
	static final int NO = 1;
	static final int NEVER = 2;

	/**
	 * listener that track resource changes
	 */
	public void resourceChanged(IResourceChangeEvent event) {
		if (fConversionPolicy == NEVER) {
			return;
		}

		switch (event.getType()) {
		case IResourceChangeEvent.PRE_CLOSE:
			break;
		case IResourceChangeEvent.PRE_DELETE:
			break;
		case IResourceChangeEvent.POST_CHANGE:
			try {
				event.getDelta().accept(this);
			} catch (CoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
			break;
		}
	}

	/**
	 * get into the resource delta and if a .gpr file was added, create the
	 * ada.makefile fragment in the same directory.
	 */
	public boolean visit(IResourceDelta delta) throws CoreException {
		final IResource res = delta.getResource();
		switch (delta.getKind()) {
		case IResourceDelta.ADDED:
			if (res.getProject().getFile(".wrproject").exists()
					&& !res.getProject().hasNature(
							GNATbenchProjectNature.NATURE_ID)) {

				if ("gpr".equals(res.getFileExtension())) {
					Display.getDefault().syncExec(new Runnable() {

						public void run() {
							MessageDialog dialog = new MessageDialog(
									null,
									"GNAT Project Added to the Workspace",
									null,
									"The File "
											+ res.getName()
											+ " has been added to the workspace in a"
											+ " non-GNATbench project. Do you want to"
											+ " setup it for GNATbench now?",
									MessageDialog.QUESTION, new String[] {
											"Yes", "No", "Never" }, 1);

							fConversionPolicy = dialog.open();
						}
					});

					if (fConversionPolicy == YES) {
						new WorkspaceJob("configure GNATbench project") {

							public IStatus runInWorkspace(
									IProgressMonitor monitor)
									throws CoreException {
								IProject project = res.getProject();

								GNATbenchProjectProperties props = GNATbenchProjectProperties
										.getPropertiesFor(project);

								GNATbenchProjectNature.addNature(project);
								project.refreshLocal(IProject.DEPTH_INFINITE,
										null);

								props.setGPRPath(res
										.getFullPath().removeFirstSegments(1)
										.toOSString());

								props.saveProjectFile();

								IGNATProjectRegistry kernel = GNATbenchSession.getDefault().getOrLoadRegistry(project);

								kernel.recompute();

								return GNATbenchCorePlugin.OK_STATUS;
							}
						}.schedule();
					}
				}
			}
			return true;
		case IResourceDelta.REMOVED:
			return false;
		case IResourceDelta.CHANGED:
			return true;
		}
		return false;
	}
}
