/*******************************************************************************
 * Copyright (c) 2005 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/


package com.adacore.gnatbench.windriver.internal;

import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.*;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;
import org.eclipse.core.resources.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class GNATbenchWindriverPlugin extends AbstractUIPlugin implements IStartup{

	//The shared instance.
	private static GNATbenchWindriverPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public GNATbenchWindriverPlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		IResourceChangeListener listener = new GPRSpy();
		ResourcesPlugin.getWorkspace().addResourceChangeListener(listener,
				IResourceChangeEvent.POST_CHANGE);

	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static GNATbenchWindriverPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("com.adacore.gnatbench.windriverbuilder", path);
	}

	public void earlyStartup() {
		// TODO Auto-generated method stub
		
	}
}
