/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.windriver.internal;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.builder.IGNATbenchProjectNatureContribution;


public class GNATbenchWRNatureContribution implements
		IGNATbenchProjectNatureContribution {

	/**
	 * Content of the Makefile fragment that takes care of GNAT project
	 * compilation.
	 */
	static final String ADA_MAKEFILE_CONTENT = "FORCE:\n\n"
			+ "$(OBJ_DIR)/%.adaobject : $(SRC_DIR)/%.gpr FORCE\n"
			+ "	@if [ `basename $< .gpr` = `basename $(PRJ_ROOT_DIR)` ]; then \\\n"
			+ "	   echo \"building Ada project $<\";\\\n"
			+ "	   gnatwrapper \"$<\" -o \"$@\" -s $(BUILD_SPEC); \\\n"
			+ "	else\\\n"
			+ "	   touch $@;\\\n"
			+ "	fi\n"
			+ "\n"
			+ "SUB_OBJECTS:=${filter-out %.adaobject, $(SUB_OBJECTS)}\n"
			+ "OBJECTS:=${filter-out %.adaobject, $(OBJECTS)} ${filter %$(notdir $(basename $(PRJ_ROOT_DIR))).adaobject, $(OBJECTS)}\n"
			+ "\n\n"
			+ "external_clean::\n"
			+ "	@echo \"cleaning Ada project `basename $(PRJ_ROOT_DIR).gpr`\";\n"
			+ "	@gnatwrapper `basename $(PRJ_ROOT_DIR).gpr` -c -s $(BUILD_SPEC)\n\n";

	/**
	 * Submit resource change job in the workspace (adding the file
	 * ada.makefile in the directory path of the workbench project project
	 */
	public void createAdaMakefile(final IProject project, final IPath path) {
		WorkspaceJob MakefileJob;
		MakefileJob = new WorkspaceJob("create ada.makefile") {
			public IStatus runInWorkspace(IProgressMonitor monitor) {
				try {
					IFile makefileFragment = project.getFile(path.toString()
							+ "/ada.makefile");
					if (!makefileFragment.exists()) {
						makefileFragment.create(new ByteArrayInputStream(
								ADA_MAKEFILE_CONTENT.getBytes()), true, null);
					}

					updateWindriverProject(project, project
							.getFile(".wrproject"));
					project.refreshLocal(IProject.DEPTH_INFINITE, null);

					// project.refreshLocal(1, null);
				} catch (Exception e) {
					GNATbenchCorePlugin.getDefault().logError(null, e);
				}
				return Status.OK_STATUS;
			}
		};

		//  ??? With the statement below, the command raises an exception when
		//  the project nature is set. Everything works fine without that so
		//  it's not clear wether it's really needed or not. To be investigated.
		//  MakefileJob.setRule(project);

		MakefileJob.schedule();
	}

	public void configure(IProject project) {
		createAdaMakefile(project, project.getProjectRelativePath()
				.removeLastSegments(1));
	}


	static Document document = null;
	static org.w3c.dom.Node mapAttribute;
	static ByteArrayOutputStream windriverproject = null;

	public static void updateWindriverProject(final IProject project, final IFile file) {
		String filename = file.getLocation().toOSString();
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		try {
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.parse(new File(filename));
		} catch (SAXException sxe) {
			Exception  x = sxe;
			if (sxe.getException() != null)
				x = sxe.getException();
			GNATbenchCorePlugin.getDefault().logError(null, x);
		} catch (ParserConfigurationException pce) {
			// Parser with specified options can't be built
			GNATbenchCorePlugin.getDefault().logError(null, pce);
		} catch (IOException ioe) {
			// I/O error
			GNATbenchCorePlugin.getDefault().logError(null, ioe);
		}

		if (hasGNATBuilderTool (document, false) == false) {
			addGNATBuilderTool (document, false);
			try {
				// Prepare the DOM document for writing
				Source source = new DOMSource(document);
				windriverproject = new ByteArrayOutputStream ();
				Result result = new StreamResult(windriverproject);

				// Write the DOM document to the file
				Transformer xformer = TransformerFactory.newInstance().newTransformer();
				xformer.setOutputProperty ("indent", "yes");
				xformer.setOutputProperty ("method", "xml");
				xformer.transform(source, result);
			} catch (TransformerConfigurationException e) {
			} catch (TransformerException e) {
			}
		}

		WorkspaceJob ProjectUpdateJob;
		ProjectUpdateJob = new WorkspaceJob("update .wrproject") {
			public IStatus runInWorkspace(IProgressMonitor monitor) {
				try {
						file.setContents(new ByteArrayInputStream(windriverproject.toByteArray()), true, false, null);
					// project.refreshLocal(1, null);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				return Status.OK_STATUS;
			}
		};
		ProjectUpdateJob.setRule(project);
		ProjectUpdateJob.schedule();
	}


	public static boolean hasGNATBuilderTool (org.w3c.dom.Node node, boolean is_tools_list) {
		org.w3c.dom.NodeList childs;
		org.w3c.dom.NamedNodeMap attributes;

		boolean is_next_tools_list = false;
		if (node.hasAttributes ()) {
			attributes = node.getAttributes ();
			if (attributes.getNamedItem ("key") != null) {
				final String key_value = attributes.getNamedItem ("key").getNodeValue ();
				if (key_value.equals ("BLD::Info|Tools")) is_next_tools_list = true;
			}
			if (is_tools_list) {
				if (attributes.getNamedItem ("value").getNodeValue ().equals ("GNAT Builder"))
				return true;
			}
		}

		if (node.hasChildNodes ()) {
			childs=node.getChildNodes ();
			for (int i=0; i < childs.getLength (); i++) {
				boolean result;
				result = hasGNATBuilderTool (childs.item (i), is_next_tools_list);
				if (result) return result;
			}
		}
		return false;
	}

	public static void appendNode (String tool, String suffix, String value, String type) {
		final String prefix = "BLD::Info|Tool|" + tool + "|";
		org.w3c.dom.Element node;
		node = document.createElement (type + "Attribute");
		node.setAttribute ("key", prefix + suffix);
		node.setAttribute ("value", value);
		mapAttribute.appendChild (node);
	}

	public static void addGNATBuilderTool  (org.w3c.dom.Node node, boolean is_spec_list) {
		org.w3c.dom.NodeList childs;
		org.w3c.dom.NamedNodeMap attributes;

		boolean is_next_spec_list = false;

		if (node.getNodeName ().equals ("mapAttribute")) mapAttribute = node;
		if (node.hasAttributes ()) {
			attributes = node.getAttributes ();
			if (attributes.getNamedItem ("key") != null) {
				final String key_value = attributes.getNamedItem ("key").getNodeValue ();
				if (key_value.equals ("BLD::Info|specs")) is_next_spec_list = true;
				if (key_value.equals ("BLD::Info|Tools")) {
					org.w3c.dom.Element new_node = document.createElement ("stringAttribute");
					org.w3c.dom.Element new_node2 = document.createElement ("stringAttribute");
					new_node.setAttribute ("value", "GNAT Builder");
					new_node2.setAttribute ("value", "GNAT Linker");
					node.appendChild (new_node);
					node.appendChild (new_node2);
				}
			}
			if (is_spec_list) {
				final String spec   = attributes.getNamedItem ("value").getNodeValue ();
				// A new spec has been detected so add the node for the GNAT builder for that spec
				appendNode ("GNAT Builder", "cmd|" + spec, "", "string");
				appendNode ("GNAT Builder", "dbgFlags|" + spec, "", "string");
				appendNode ("GNAT Builder", "derivedSigs|" + spec, "*.adaobject", "string");
				appendNode ("GNAT Builder", "flags|" + spec, "", "string");
				appendNode ("GNAT Builder", "nonDbgFlags|" + spec, "", "string");
				appendNode ("GNAT Builder", "object", "true", "boolean");
				appendNode ("GNAT Builder", "passAble", "false", "boolean");
				appendNode ("GNAT Builder", "sigs", "*.gpr", "string");
				appendNode ("GNAT Linker", "cmd|" + spec, "echo \"%Objects%\"; cp $(OBJ_DIR)/`basename $(PRJ_ROOT_DIR)`.adaobject %OutFile%", "string");
				appendNode ("GNAT Linker", "dbgFlags|" + spec, "", "string");
				appendNode ("GNAT Linker", "derivedSigs|" + spec, "*.vxe", "string");
				appendNode ("GNAT Linker", "flags|" + spec, "", "string");
				appendNode ("GNAT Linker", "nonDbgFlags|" + spec, "", "string");
				appendNode ("GNAT Linker", "object", "false", "boolean");
				appendNode ("GNAT Linker", "passAble", "false", "boolean");
				appendNode ("GNAT Linker", "sigs", "", "string");
			}
		}
		if (node.hasChildNodes ()) {
			childs=node.getChildNodes ();
			for (int i=0; i < childs.getLength (); i++)
				addGNATBuilderTool (childs.item (i), is_next_spec_list);
		}
	}

} // GNATbenchWRNatureContribution
