/*******************************************************************************
 * Copyright (c) 2006 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.windriver.internal;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;

public class GNATbenchPerspectiveFactory implements IPerspectiveFactory {
	
	private static final String ProjectExplorer = 
	    "com.adacore.gnatbench.ui.projectexplorer.ProjectExplorer";
	
	private static final String ScenarioVars = 
	    "com.adacore.gnatbench.ui.ScenarioVariables";

	private static final String WRSBuilderConsole = 
	    "com.windriver.ide.ui.build.WRBuildConsoleView";

	private static final String WRSProjectNavigator = 
	    "com.windriver.ide.ui.project.WRProjectView";
	
	public void createInitialLayout(IPageLayout layout) {
		
		String editorArea = layout.getEditorArea();
		
		IFolderLayout topLeft = layout.createFolder(
				"topLeft", 
				IPageLayout.LEFT, 
				0.25f, 
				editorArea);
		topLeft.addView(WRSProjectNavigator);		
		topLeft.addView(ProjectExplorer);
		
		IFolderLayout bottom = layout.createFolder(
				"bottom", 
				IPageLayout.BOTTOM, 
				0.75f, 
				editorArea); 
		bottom.addView(IPageLayout.ID_PROBLEM_VIEW);
		bottom.addView(IPageLayout.ID_TASK_LIST);
		bottom.addView(IConsoleConstants.ID_CONSOLE_VIEW);  	
		bottom.addView(ScenarioVars);
		bottom.addView(WRSBuilderConsole);		
		
		IFolderLayout topRight = layout.createFolder(
				"topRight", 
				IPageLayout.RIGHT, 
				0.75f, 
				editorArea);
		topRight.addView(IPageLayout.ID_OUTLINE);
				
	} // createInitialLayout

} // GNATbenchPerspectiveFactory

