/*******************************************************************************
 * Copyright (c) 2006 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.windriver.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;

import com.adacore.gnatbench.core.internal.toolchain.IGNATbenchToolChain;
import com.windriver.ide.util.IBuildSpecAccessor;

public class GNATbenchCrossToolChain implements IGNATbenchToolChain {

	public String [] buildCommand(IProject project) {
		return new String [] {builderName(project)};
	} // buildCommand

	public String [] compileCommand(IProject project) {
		return new String [] {builderName(project), "-c"};
	} // compileCommand

	public String name(IProject project) {
		return builderName(project);
	} // name
	
	public String [] gnatlsCommand (final IProject project) {
		final String compilerName = builderName(project);
		if (compilerName.equalsIgnoreCase("gprbuild")) {
			// return ???
		} // if
		final int last = compilerName.lastIndexOf("make");
		final String toolNamePrefix = compilerName.substring(0,last);		
		return new String [] {toolNamePrefix + "ls"};
	} // gnatlsCommand	
	
	protected String builderName(IProject project) {
		IAdaptable a = (IAdaptable) project;
		IBuildSpecAccessor buildSpec = (IBuildSpecAccessor) a.getAdapter(IBuildSpecAccessor.class);
		String defaultBuildSpec = buildSpec.getDefaultBuildSpec();
		
		if (defaultBuildSpec.startsWith("PPC")) {
			return "powerpc-wrs-vxworks-gnatmake";
		} // if		
		if (defaultBuildSpec.startsWith("SIM")) {
			return "i586-wrs-vxworks-gnatmake";
		} // if
		if (defaultBuildSpec.contains("PENTIUM")) {
			return "i586-wrs-vxworks-gnatmake";
		} // if
		
		// we really should not get here
		return "";
	} // builderName

} // GNATbenchCrossToolChain
