/*
 * @author michael.scharf@windriver.com
 */
package com.windriver.ide.util;

/**
 * @author michael.scharf@windriver.com
 * A class to access buildspec info of a resource (or in general)
 * <p>
 * Use <code>IResource.getAdapter(IBuildSpecAccessor.class)</code> to get
 * a IBuildSpecAccessor for a resource.
 * <p>Note: at the moment build specs are defined at project level, but this might
 * change in the future...
 */
public interface IBuildSpecAccessor {
    /**
     * @return the default build spec or null
     */
    String getDefaultBuildSpec();

    /**
     * @return the currently active build spec or null
     */
    String getActiveBuildSpec();

    /**
     * @return all build spec IDs (of this project) (never null)
     */
    String[] getAllBuildSpecs();

    /**
     * @return all enabled build spec IDs (of this project) (never null)
     */
    String[] getAvailableBuildSpecs();

    /**
     * @param buildSpecId
     * @return a list of defined macros for this build spec (never null)
     */
    String[] getBuildMacroNames(String buildSpec);

    /**
     * @param buildSpecId
     * @param macroName
     * @return the value of this macro or null
     */
    String getBuildMacro(String buildSpec, String macroName);

    /**
     * @param buildSpec
     * @return A name that should be used in the UI
     */
    String getDisplayName(String buildSpec);
}
