/*******************************************************************************
 * Copyright (c) 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.utils;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DisplayUtils {

	static public void displayError(final String title, final String msg) {	
		Display display= Display.getCurrent();
		if (display == null) {
			display= Display.getDefault();
		} // if		
		display.asyncExec(new Runnable() {
			public void run() {
				MessageDialog.openError(
						PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
						title, 
						msg);
			} // run
		});
	} // displayError
	
	
	static public void displayWarning(final String title, final String msg) {	
		Display display= Display.getCurrent();
		if (display == null) {
			display= Display.getDefault();
		} // if		
		display.asyncExec(new Runnable() {
			public void run() {
				MessageDialog.openWarning(
						PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
						title, 
						msg);
			} // run
		});
	} // displayWarning


} // DisplayUtils
