/*****************************************************************************
 * Copyright (c) 2006, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.scenariovars;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.projects.IGNATProjectRegistry;
import com.adacore.gnatbench.core.projects.IGNATProjectRegistryFactoryListener;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

/**
 * This view lets the user view and change scenario variables for open 
 * Ada projects.
 */
public class ScenarioVarsView 
	extends ViewPart 
	implements DisposeListener, IGNATProjectRegistryFactoryListener
{	
	
	private ColumnViewer viewer;	
	
	public ScenarioVarsView () {
	} // ScenarioVarsView

	
	public void createPartControl(Composite parent) {
	    viewer = createMultiColumnViewer(parent);

	    viewer.setContentProvider(new ScenarioVarsContentProvider());
	    viewer.setLabelProvider(new ScenarioVarsLabelProvider());

	    viewer.setInput(new Integer (0));

	    viewer.setSorter(new ScenarioVarsSorter());
	    
	    viewer.refresh();
	    
	    GNATbenchSession.getDefault().getProjectRegistryFactory()
		.addListener(this);	
	} // createPartControl
	

	protected ColumnViewer createMultiColumnViewer(final Composite parent) {
		final Tree tree = new Tree(parent, SWT.H_SCROLL | SWT.V_SCROLL
		        | SWT.SINGLE | SWT.FULL_SELECTION);

		TreeColumnLayout layout = new TreeColumnLayout();
		parent.setLayout(layout);
		tree.setLinesVisible(true);
		tree.setHeaderVisible(true);
				
		TreeColumn column0 = new TreeColumn(tree, SWT.NONE);
		column0.setText("Variable");
		column0.setAlignment(SWT.LEFT);
		column0.setResizable(true);
		layout.setColumnData(column0, new ColumnWeightData(5, 40, true));

		TreeColumn column1 = new TreeColumn(tree, SWT.NONE);
		column1.setText("Value");
		column1.setAlignment(SWT.LEFT);
		column1.setResizable(true);	
		layout.setColumnData(column1, new ColumnWeightData(10, true));
		
		final TreeViewer treeViewer = new TreeViewer (tree);
		
		TreeViewerColumn treeViewerColumn = 
			new TreeViewerColumn (treeViewer, column1);
		treeViewerColumn.setEditingSupport(
				new ScenarioVarsEditingSupport(treeViewer, tree, treeViewer));

		return treeViewer;
	} // createMultiColumnViewer
	
	
	public void widgetDisposed(DisposeEvent e) {
		GNATbenchSession.getDefault().getProjectRegistryFactory()
				.removeListener(this);
	} // widgetDisposed
	
	
	public void recompute() {
		new UIJob ("Update Scenario Var View") {							
			public IStatus runInUIThread(IProgressMonitor monitor) {
				viewer.refresh();
				return new Status(IStatus.OK, GNATbenchUIPlugin
						.getId(), IStatus.OK, "", null);
			}}.schedule();
	} // workspaceRecomputed

	public void setFocus() {		
	} // setFocus


	public void registryAdded(IGNATProjectRegistry reg) {
		recompute ();
	}


	public void registryRemoved(IGNATProjectRegistry reg) {
		recompute ();
	}
	
	
} // ScenarioVarsView
