/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.scenariovars;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.gpswrappers.ScenarioVariable;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;

public class ScenarioVarsSorter extends ViewerSorter {
	
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		if (e1 instanceof GNATProjectRegistry) {
			GNATProjectRegistry reg1 = (GNATProjectRegistry) e1;
			GNATProjectRegistry reg2 = (GNATProjectRegistry) e2;
			
			String prj1Name = "";
			String prj2Name = "";
			
			IProject prj;
			
			try {
				prj = reg1.getRootProject().getEclipseProject();
				
				if (prj != null) {
					prj1Name = prj.getName();
				} else {
					prj1Name = reg1.getRootProject().getName();
				}
			} catch (GNATbenchCoreException e3) {
			}
			
			try {
				prj = reg2.getRootProject().getEclipseProject();
				
				if (prj != null) {
					prj2Name = prj.getName();
				} else {
					prj2Name = reg2.getRootProject().getName();
				}
			} catch (GNATbenchCoreException e3) {
			}
			
			return super.compare(viewer, prj1Name, prj2Name);
		} else if (e1 instanceof ScenarioVariable) {
			ScenarioVariable var1 = (ScenarioVariable) e1;
			ScenarioVariable var2 = (ScenarioVariable) e2;
			
			return super.compare(viewer, var1.getExternalName(), var2
					.getExternalName());
		}
		
		return 0;
	} // compare

} // ScenarioVarsSorter