/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.scenariovars;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.gpswrappers.ScenarioVariable;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class ScenarioVarsLabelProvider 
	extends LabelProvider implements ITableLabelProvider
{

	public Image getColumnImage(Object element, int columnIndex) {
		if (element instanceof GNATProjectRegistry) {
			if (columnIndex == 0) {
				return GNATbenchUIPlugin.getDefault().getImage(
						GNATbenchUIPlugin.ICON_PROJECT);
			}
		}
		
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof GNATProjectRegistry) {
			if (columnIndex == 0) {
				try {
					GNATProjectRegistry registry = (GNATProjectRegistry) element;
					
					IProject prj = registry.getRootProject().getEclipseProject();
					
					if (prj != null) {
						return prj.getName();
					} else {
						return registry.getRootProject().getName();
					}
				} catch (GNATbenchCoreException e) {
					return "";
				}
			}
		} else if (element instanceof ScenarioVariable) {
			ScenarioVariable var = (ScenarioVariable) element;
			
			if (columnIndex == 0) {
				return var.getExternalName (); 
			} else if (columnIndex == 1) {
				return var.getValue();
			}
		}
		
		return "";
	}

	
} // ScenarioVarsLabelProvider