/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.scenariovars;

import java.util.LinkedList;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Tree;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.ScenarioVariable;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;

public class ScenarioVarsEditingSupport extends EditingSupport {
	private final Tree tree;

	private final TreeViewer treeViewer;

	public ScenarioVarsEditingSupport(ColumnViewer viewer, Tree tree,
			TreeViewer treeViewer) {
		super(viewer);
		this.tree = tree;
		this.treeViewer = treeViewer;
	} // ScenarioVarsEditingSupport

	@Override
	protected boolean canEdit(Object element) {
		if (!(element instanceof ScenarioVariable)) {
			return false;
		}

		ScenarioVariable var = (ScenarioVariable) element;

		return var.getPossibleValues().size() > 0;
	} // canEdit

	@Override
	protected CellEditor getCellEditor(Object element) {
		ScenarioVariable var = (ScenarioVariable) element;

		ComboBoxCellEditor cellEditor = new ComboBoxCellEditor(tree, var
				.getPossibleValues().toArray(new String[0]), SWT.READ_ONLY);

		return cellEditor;
	} // getCellEditor

	@Override
	protected Object getValue(Object element) {
		ScenarioVariable var = (ScenarioVariable) element;

		LinkedList <String> vals = var.getPossibleValues();
		String currentVal = var.getValue();

		int i = 0;

		for (String val : vals) {
			if (val.equals(currentVal)) {
				return new Integer (i);
			}

			++i;
		}

		return new Integer (0);
	} // getValue

	@Override
	protected void setValue(Object element, Object value) {
		ScenarioVariable var = (ScenarioVariable) element;
		Integer index = (Integer) value;

		GNATProjectRegistry registry = var.getGPRProject().getRegistry();

		try {
			String newValue = var.getPossibleValues().get(index.intValue());

			if (!newValue.equals(var.getValue())) {
				var.setValue(newValue);
				treeViewer.refresh(element);

				registry.recompute();
			}
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}
	} // setValue

} // ScenarioVarsEditingSupport
