/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.scenariovars;

import java.util.LinkedList;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.GNATbenchProjectProperties;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.core.projects.IGNATProjectRegistry;
import com.adacore.gnatbench.core.projects.IGNATProjectRegistryListener;

public class ScenarioVarsContentProvider implements ITreeContentProvider,
		IGNATProjectRegistryListener {

	private Viewer fViewer;
	private Object fRoot;

	public ScenarioVarsContentProvider() {
	} // ScenarioVarsContentProvider


	public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		fRoot = newInput;
		v.refresh();
		fViewer = v;
	} // inputChanged


	public void dispose() {
	} // dispose


	public Object[] getElements(Object parent) {
		fRoot = parent;
		return getChildren (parent);
	} // getElements


	public Object[] getChildren(Object parentElement) {
		LinkedList<Object> result = new LinkedList<Object>();

		if (parentElement == fRoot) {
			IProject[] projects = ResourcesPlugin.getWorkspace().getRoot()
			.getProjects();

			for (int i = 0; i < projects.length; ++i) {
				IProject project = projects [i];

				GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
						.getDefault().getOrLoadRegistry(project);

				if (registry == null || !registry.isValid()) {
					continue;
				}

				registry.addListener(this);

				GNATbenchProjectProperties props = GNATbenchProjectProperties
				.getPropertiesFor(project);

				if (props == null) {
					continue;
				}

				if (props.isRootProject()) {
					result.add(registry);
				}
			}
		} else if (parentElement instanceof GNATProjectRegistry) {
			GNATProjectRegistry kernel = (GNATProjectRegistry) parentElement;

			GPRProject gprProject = kernel.getRootProject();

			try {
				gprProject.loadScenarioVariables();
				result.addAll(gprProject.getScenarioVariables());
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			} // try
		}

		return result.toArray();

	}

	public Object getParent(Object element) {
		if (element instanceof IProject) {
			return fRoot;
		}

		return null;
	}


	public boolean hasChildren(Object element) {
		if (element == fRoot || element instanceof GNATProjectRegistry) {
			return true;
		}

		return false;
	}

	public void recomputed(IGNATProjectRegistry registry) {
		fViewer.refresh();
	}

} // ScenarioVarsContentProvider