/*******************************************************************************
 * Copyright (C) 2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.quickfix;

import org.eclipse.core.resources.IMarker;

/**
 * This listener is used to track the work done by the quick fix assistant.
 */
public interface IQuickFixListener {

	/**
	 * This function is called whenever a marker is analysed by the quick fix
	 * listener assistant, no matter if it issued a fix in the end or not.
	 *
	 * @param assistant
	 * @param marker
	 */
	public void markerAnalyzed (QuickFixKernelAssistant assistant, IMarker marker);

}
