/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.quickfix;

import java.util.LinkedList;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedLocation;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Codefix.Formal_Errors.Solution_List;
import com.adacore.gnatbench.library.Codefix.Formal_Errors.Solution_List_Iterator;
import com.adacore.gnatbench.library.Codefix.Text_Manager.Text_Command;
import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;

public class GNATbenchQuickAssistProcessor implements IQuickAssistProcessor {

	private AdaEditor fEditor;

	public GNATbenchQuickAssistProcessor (AdaEditor editor) {
		fEditor = editor;
	}

	static class CodefixCompletionProposal implements ICompletionProposal {

		private Text_Command fCommand;
		private String fDisplayedString;
		private GeneralizedLocation fLocation;
		private QuickFixKernelAssistant fFixKernel;

		/**
		 * Create a proposal that will perform the given command, from the
		 * given location, from the infomration of a kernel assistant.
		 * @param comm
		 * @param loc
		 * @param fixKernel
		 */
		public CodefixCompletionProposal(Text_Command comm,
				GeneralizedLocation loc, QuickFixKernelAssistant fixKernel) {
			fCommand = comm;
			fLocation = loc;
			fFixKernel = fixKernel;

			LibraryMonitor monitor = LibrarySemaphore.startGPSWork();

			try {
				fDisplayedString = fCommand.Get_Caption().toString();
			} finally {
				LibrarySemaphore.stopGPSWork(monitor);
			}
		}

		public void apply(IDocument document) {
			LinkedList<IMarker> markers = fFixKernel
					.getErrorsAtLocation(fLocation);

			LibraryMonitor monitor = LibrarySemaphore.startGPSWork();

			try {
				fCommand.Secured_Execute(fFixKernel.getQuickFixNav(), null);
			} finally {
				LibrarySemaphore.stopGPSWork(monitor);
			}

			for (IMarker marker : markers) {
				if (marker.exists()) {
					try {
						marker.delete ();
					} catch (CoreException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					}
				}
			}
		}

		public String getAdditionalProposalInfo() {
			return "Additional info";
		}

		public IContextInformation getContextInformation() {
			// TODO Auto-generated method stub
			return null;
		}

		public String getDisplayString() {
			return fDisplayedString;
		}

		public Image getImage() {
			// TODO Auto-generated method stub
			return null;
		}

		public Point getSelection(IDocument document) {
			// TODO Auto-generated method stub
			return null;
		}

	}

	public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean canFix(Annotation annotation) {
		// TODO Auto-generated method stub
		return false;
	}

	public ICompletionProposal[] computeQuickAssistProposals(
			IQuickAssistInvocationContext invocationContext) {

		LibraryMonitor libMonitor = LibrarySemaphore.startGPSWork();

		try {
			GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
					.getDefault().getOrLoadRegistry(
							fEditor.getFile().getProject());

			QuickFixKernelAssistant fixAssistant = (QuickFixKernelAssistant) registry
					.getAssistant(QuickFixKernelAssistant.ASSISTANT_ID);

			IDocument doc = invocationContext.getSourceViewer().getDocument();
			int line = doc.getLineOfOffset(invocationContext.getOffset()) + 1;

			LinkedList<ICompletionProposal> fixes = new LinkedList<ICompletionProposal>();

			GeneralizedLocation loc = GeneralizedLocation.fromAbsoluteLocation(
					fEditor.getFile(), line, invocationContext.getOffset());

			Solution_List sols = fixAssistant.getSolutions(loc);

			if (sols == null) {
				return new ICompletionProposal [0];
			}

			Solution_List_Iterator sol_it = sols.First();

			while (!sol_it.At_End()) {
				fixes.add(new CodefixCompletionProposal(sol_it.Get_Command(),
						loc, fixAssistant));

				sol_it = sol_it.Next();
			}

			ICompletionProposal [] result = new ICompletionProposal [fixes.size()];

			int j = 0;
			for (ICompletionProposal prop : fixes) {
				result [j] = prop;
				j++;
			}

			return result;
		} catch (BadLocationException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} finally {
			LibrarySemaphore.stopGPSWork(libMonitor);
		}

		return null;
	}

	public String getErrorMessage() {
		// TODO Auto-generated method stub
		return null;
	}

}
