/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.quickfix;

import java.util.LinkedList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedLocation;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Codefix.Formal_Errors.Solution_List;
import com.adacore.gnatbench.library.Codefix.Formal_Errors.Solution_List_Iterator;
import com.adacore.gnatbench.library.Codefix.Text_Manager.Text_Command;

public class GNATbenchMarkerResolution implements IMarkerResolutionGenerator,
		IMarkerResolutionGenerator2 {

	class GNATbenchResolution implements IMarkerResolution {

		Text_Command fCommand;
		QuickFixKernelAssistant fAssistant;
		IMarker fMarker;

		public GNATbenchResolution(Text_Command command,
				QuickFixKernelAssistant assistant, IMarker marker) {
			fCommand = command;
			fAssistant = assistant;
			fMarker = marker;
		}

		public String getLabel() {
			LibraryMonitor monitor = LibrarySemaphore.startGPSWork();

			try {
				return fCommand.Get_Caption().toString();
			} finally {
				LibrarySemaphore.stopGPSWork(monitor);
			}
		}

		public void run(IMarker marker) {
			LinkedList<IMarker> similarMarkers = fAssistant
			.getErrorsAtLocation(GeneralizedLocation
					.fromTextMarker(marker));

			LibraryMonitor monitor = LibrarySemaphore.startGPSWork();

			try {
				fCommand.Secured_Execute(fAssistant.getQuickFixNav(), null);
			} finally {
				LibrarySemaphore.stopGPSWork(monitor);
			}

			try {
				for (IMarker oldMarker : similarMarkers) {
					oldMarker.delete();
				}
			} catch (CoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		}
	}

	public IMarkerResolution[] getResolutions(IMarker marker) {
		if (!(marker.getResource() instanceof IFile)) {
			return new IMarkerResolution [0];
		}

		GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(
						marker.getResource().getProject());

		QuickFixKernelAssistant fixAssistant = (QuickFixKernelAssistant) registry
				.getAssistant(QuickFixKernelAssistant.ASSISTANT_ID);

		LinkedList<IMarkerResolution> result = new LinkedList<IMarkerResolution>();

		LibraryMonitor monitor = LibrarySemaphore.startGPSWork();

		try {
			Solution_List solutions = fixAssistant
					.getSolutions(GeneralizedLocation.fromTextMarker(marker));

			Solution_List_Iterator it = solutions.First();

			while (!it.At_End()) {
				result.add(new GNATbenchResolution(it.Get_Command(),
						fixAssistant, marker));

				it = it.Next();
			}
		} finally {
			LibrarySemaphore.stopGPSWork(monitor);
		}

		return result.toArray(new IMarkerResolution [result.size()]);
	}

	public boolean hasResolutions(IMarker marker) {
		if (!(marker.getResource() instanceof IFile)) {
			return false;
		}

		GNATProjectRegistry registry = (GNATProjectRegistry) GNATbenchSession
		.getDefault().getOrLoadRegistry(
				marker.getResource().getProject());

		QuickFixKernelAssistant fixAssistant = (QuickFixKernelAssistant) registry
				.getAssistant(QuickFixKernelAssistant.ASSISTANT_ID);

		return fixAssistant.isFixable(GeneralizedLocation
				.fromTextMarker(marker));
	}

}
