/*******************************************************************************
 * Copyright (c) 2006, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.ui.internal.projectexplorer;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GPS;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;

public class OpenGPRProperties implements IObjectActionDelegate {

	GPRProject fProject = null;
	
	public OpenGPRProperties() {
		super();
		// TODO Auto-generated constructor stub
	}

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		// TODO Auto-generated method stub
		
	}

	public void run(IAction action) {
		if (fProject != null) {
			GPS.launchGPS (fProject, "edit_properties.py", " --hide");
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		IStructuredSelection structuredSelection = 
			(IStructuredSelection) selection;
		
		Object first = structuredSelection.getFirstElement();
		
		if (first instanceof IProject) {
			fProject = ((GNATProjectRegistry) GNATbenchSession.getDefault()
					.getOrLoadRegistry((IProject) first))
					.getGPRFor((IProject) first);
		}
		
	}

}
