/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.projectexplorer;

import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.ViewerSorter;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.filesystem.FileStoreReference;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;

/**
 * Provide sorting for element generated by the GPRExplorer
 *
 * @since 2.2
 */
public class GPRExplorerViewerSorter extends ViewerSorter {
	public int category (Object obj) {
		if (obj instanceof IFolder) {
			IFolder folder = (IFolder) obj;

			try {
				if (GNATProjectRegistry.isManagedSourceFolder(folder)) {
					return 1;
				} else if (GNATProjectRegistry.isManagedBinaryFolder(folder)) {
					return 4;
				}
			} catch (GNATbenchCoreException e) {
				GNATbenchCorePlugin.getDefault().logError(null, e);
			}
		} else if (obj instanceof AdaDependenciesNode) {
			return 2;
		} else if (obj instanceof AdaRuntimeNode) {
			return 3;
		} else if (obj instanceof FileStoreReference) {
			FileStoreReference ref = (FileStoreReference) obj;

			if (GNATProjectRegistry.isManagedSourceFolder(ref
					.getFileStore())) {
				return 1;
			} else if (GNATProjectRegistry.isManagedBinaryFolder(ref
					.getFileStore())) {
				return 4;
			}
		}

		return 999;
	}
}