/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.ui.internal.projectexplorer;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.ILinkHelper;

import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;

public class GPRExplorerLinkHelper implements ILinkHelper {
	
	public void activateEditor(IWorkbenchPage page,
			IStructuredSelection selection) {
		// TODO Auto-generated method stub
	}

	public IStructuredSelection findSelection(IEditorInput anInput) {
		GeneralizedFile file = GeneralizedFile.fromEditorInput(anInput);
		
		if (file != null) {
			if (file.getFile() != null) {
				return new StructuredSelection (file.getFile());	
			} else {
				return new StructuredSelection(file.getFileStore());
			}
		}
		
		return null;
	}

}
